/*
	File:		PackageTypes.h

	Copyright:	 1992-1996 by Apple Computer, Inc., all rights reserved.

	Derived from v1 internal, 1/8/96.

*/


#ifndef __PACKAGETYPES_H
#define __PACKAGETYPES_H

// the following are various sourcetypes bits

#define kStream 		 		0x0
#define kFixedMemory 	 		0x1
#define kRemovableStream 		0x2
#define kRemovableMemory 		0x3

#define kRemovableMask      	0x2
#define kFormatMask				0x1


// device types

#define kNoDevice				0x0
#define kCardDevice				0x1
#define kSerialDevice			0x2
#define kIRDevice				0x3
#define kOtherDevice			0x4
#define kStoreDevice			0x5
#define kStoreDeviceV2			0x6


// part types

#define kProtocol 				0
#define kFrames   				1
#define kRaw      				2


#ifndef FRAM

#ifndef __NEWTONTYPES_H
#include "NewtonTypes.h"
#endif

typedef ULong	PartType;
typedef Long	PartKind;

#endif	//	Fram

#if defined(forNTK) || !defined(forDocker)

#ifndef FRAM

typedef Long		RemoveObjPtr;


#ifndef __KERNELTYPES_H
#include "KernelTypes.h"
#endif



// the magic number header for a package
extern const Byte	kPackageMagicNumber[7];

const Long kMaxInfoSize 		  = 64;
const Long kMaxCompressorNameSize = 32;
const Long kMaxPackageNameSize 	  = 32;


typedef struct PartId
{
	TObjectId 	packageId;
	Long		partIndex;
} PartId;


typedef struct SourceType
{
	UByte 	format;
	UByte 	deviceKind;
	UShort 	deviceNumber;
	ULong 	deviceId;
} SourceType;




inline Boolean IsRemovable( SourceType type ) {
	return ( type.format & kRemovableMask );
}

inline Boolean IsPersistent( SourceType type ) {
	return ( !(type.format & kRemovableMask) );
}

inline Boolean IsStream( SourceType type ) {
	return ( !(type.format & kFormatMask ) );
}

inline Boolean IsMemory( SourceType type ) {
	return ( (type.format & kFormatMask ) );
}





typedef struct PartInfo
{
	PartKind	kind;
	PartType	type;
	ULong		size;
	ULong		sizeInMemory;
	ULong		infoSize;
	void*		info;
	char*		compressor;
	ULong		data;				// stream: offset, ram: absolute address
	Boolean		autoLoad;
	Boolean		autoRemove;
	Boolean		compressed;
	Boolean		notify;
	Boolean		autoCopy;
} PartInfo;


typedef struct ExtendedPartInfo : PartInfo
{
	Character		packageName[kMaxPackageNameSize +1];
} ExtendedPartInfo;


typedef struct StreamSource {
	TObjectId	bufferId;
	TObjectId	messagePortId;
} StreamSource;

typedef struct MemSource {
	VAddr	buffer;
	ULong	size;
} MemSource;


typedef union PartSource {
	StreamSource stream;
	MemSource	 mem;
} PartSource;


#define kIterateOnAllPackages 0xFFFFFFFF


// reserved part types:
// this part type id is the id of the part handler that autoloads forms
const PartType kFormPartType    =	'form';
const PartType kPatchPartType 	=   'ptch';



#endif //FRAM

#endif // Docker

#endif
